/* ******************************************************************************************************* */
/* Programmet använder 'x' istället för '*' som sin multiplikationsoperator */
/* detta är medvetet eftersom '*' tolkas först av bash som ställer till massvis med problem */
/* ****************************************************************************************************** */
#include <stdio.h>

#include "parser/parser.h"
#include "math/math.h"

int
main (int argc, char *argv[])
{
  double parsed_val;
  
  
  parsed_val = parser (argc, argv); /*puts the arguments through the parser, and then gives the return values to parsed_val*/
                                    /* the return values signal if the command line arguments are valid or not; and if not, allows us to interpret what the underlying problem is */
  
  if (parsed_val != 0) /* takes the return value of parser() and, if it is NOT equal to 0 (0 being the successful condition), returns it to the OS/process etc, exiting the program at the same time */
    {
      return parsed_val;
    }
  else
    {      
      fprintf (stdout, "Result: %g\n", math(argc, argv)); /* if all conditions are met, the result is passed to stdout and the program exits with a success value (0) */
      return 0;
    }
}



